<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('claim_documents', function (Blueprint $table) {
            $table->id();

            // Foreign Keys
            $table->foreignId('claim_id')->constrained('claims')->onDelete('cascade');
            $table->foreignId('customer_id')->nullable()->constrained('customers')->onDelete('cascade');
            $table->foreignId('corporate_customer_id')->nullable()->constrained('corporate_customers')->onDelete('cascade');

            // Document details
            $table->string('document_type'); // e.g., "Police Report", "Medical Report"
            $table->string('file_path');     // path to file in storage
            $table->string('file_name');
            $table->string('mime_type');
            $table->unsignedBigInteger('file_size'); // in bytes

            $table->text('description')->nullable();

            // Tracking
            $table->foreignId('uploaded_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamp('uploaded_at')->useCurrent();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('claim_documents');
    }
};
